% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip}
\alias{pip}
\title{Calculates posterior inclusion probabilities (PIPs) for modifiers in HDLM & HDLMM}
\usage{
pip(object, type = 1)
}
\arguments{
\item{object}{An object of class dlmtree.}

\item{type}{Type=1 indicates single modifier PIPs. Type=2 indicates joint modifier PIPs for two modifiers.}
}
\value{
numeric vector of PIPs named with modifiers (type=1) or data.frame of PIPs with the following columns (type=2):
\item{var1}{first modifier of joint modifiers}
\item{var2}{second modifier of joint modifiers}
\item{pip}{joint PIPs for the two modifiers}
}
\description{
Method for calculating posterior inclusion probabilities (PIPs) for modifiers in HDLM & HDLMM
}
\details{
pip
}
\examples{
\donttest{
# Posterior inclusion probability with HDLM 
D <- sim.hdlmm(sim = "B", n = 1000)
fit <- dlmtree(y ~ ., 
               data = D$dat,
               exposure.data = D$exposures,
               dlm.type = "linear",
               family = "gaussian",
               het = TRUE)
pip(fit)
pip(fit, type = 2)
}

}
