% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri_llm_response.R
\name{get_dri_llm_response}
\alias{get_dri_llm_response}
\title{Get DRI LLM Response}
\usage{
get_dri_llm_response(
  model_id,
  survey_info = list(type = NA_character_, order = NA_integer_, statement =
    NA_character_, name = NA_character_, scale_max = NA_integer_, q_method = NA),
  api_key = Sys.getenv("OPENROUTER_API_KEY"),
  role_info = list(uid = NA_character_, role = NA_character_, description =
    NA_character_),
  n = 1,
  request_log_path = NA_character_
)
}
\arguments{
\item{model_id}{a model_id string from openrounter.ai}

\item{survey_info}{a list with survey question information, including \code{type},
\code{order}, \code{statement}, \code{name}, \code{scale_max}, and \code{q_method}}

\item{api_key}{the API key generated by OpenRouter}

\item{role_info}{a named list with basic data of a role (i.e., \code{uid},
\code{role}, \code{description})}

\item{n}{the number of responses requested (default = 1)}

\item{request_log_path}{an optional path to a file where the request texts
are saved}
}
\value{
a dataframe with \code{n} survey responses by \code{model_id}, including a
unique identifier, \code{uuid}, a creation timestamp, \code{created_at_utc}, the time
it took to generate the response, \code{time_s}, the estimated cost in USD,
\code{est_cost_usd}, whether the response is valid, \code{is_valid}, and the reason it
is not, \code{invalid_reason}
}
\description{
\code{get_dri_llm_response} uses \url{https://openrouter.ai} to generate artificial LLM
responses to DRI survey questions
}
\examples{

# get DRI survey
survey_info <- surveys[surveys$name == "acp",]

# select a model from openrouter
model_id <- "google/gemini-2.5-flash-lite"

# send request to openrouter API
\dontrun{
llm_data <- get_dri_llm_response(model_id, survey_info)}

}
\seealso{
\code{\link[=get_model_ids]{get_model_ids()}} for all currently available model ids from
openrouter.ai

Other LLM methods: 
\code{\link{get_model_ids}()},
\code{\link{make_dri_llm_prompts}()}
}
\concept{LLM methods}
