% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_mahalanobis.R
\name{acc_mahalanobis}
\alias{acc_mahalanobis}
\title{Calculate and plot Mahalanobis distances for social science indices}
\usage{
acc_mahalanobis(
  variable_group = NULL,
  label_col = VAR_NAMES,
  study_data,
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2,
  mahalanobis_threshold =
    suppressWarnings(as.numeric(getOption("dataquieR.MAHALANOBIS_THRESHOLD",
    dataquieR.MAHALANOBIS_THRESHOLD_default)))
)
}
\arguments{
\item{variable_group}{\link{variable list} the names of the continuous
measurement variables building
a group, for that multivariate outliers
make sense.}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{mahalanobis_threshold}{\link{numeric} TODO: ES}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: \link{data.frame} underlying the plot
\item \code{SummaryPlot}: \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} outlier plot
\item \code{FlaggedStudyData} \link{data.frame} contains the original data frame with
the additional columns \code{tukey},
\verb{3SD},
\code{hubert}, and \code{sigmagap}. Every
observation
is coded 0 if no outlier was detected in
the respective column and 1 if an
outlier was detected. This can be used
to exclude observations with outliers.
}
}
\description{
A standard tool to calculate Mahalanobis distance.
In this approach the Mahalanobis distance is calculated for ordinal
variables (treated as continuous) to identify inattentive responses.
It calculates the distance for each observational unit from the sample mean.
The greater the distance, the atypical the responses.

\link{Indicator}
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Implementation is restricted to variables of type integer
\item Remove missing codes from the study data (if defined in the metadata)
\item The covariance matrix is estimated for all variables from \code{variable_group}
\item The Mahalanobis distance of each observation is calculated
\eqn{MD^2_i  = (x_i - \mu)^T \Sigma^{-1} (x_i -  \mu)}
\item The default to consider a value an outlier is "use the 0.975 quantile
of a chi-square distribution with p degrees of freedom" (Mayrhofer and Filzmoser, 2023)
List function.
}
}

\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_multivariate_outlier.html}{Online Documentation}
}
