% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_distributions.R
\name{acc_distributions_loc}
\alias{acc_distributions_loc}
\title{Plots and checks for distributions -- Location}
\usage{
acc_distributions_loc(
  resp_vars = NULL,
  study_data,
  label_col = VAR_NAMES,
  item_level = "item_level",
  check_param = "location",
  plot_ranges = TRUE,
  flip_mode = "noflip",
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable list} the names of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{check_param}{\link{enum} any | location | proportion. Which type of check
should be conducted (if possible): a check on the
location of the mean or median value of the study
data, a check on proportions of categories, or either
of them if the necessary metadata is available.}

\item{plot_ranges}{\link{logical} Should the plot show ranges and results from the
data quality checks? (default: TRUE)}

\item{flip_mode}{\link{enum} default | flip | noflip | auto. Should the plot be
in default orientation, flipped, not flipped or
auto-flipped. Not all options are always supported.
In general, this con be controlled by
setting the \code{roptions(dataquieR.flip_mode = ...)}. If
called from \code{dq_report}, you can also pass
\code{flip_mode} to all function calls or set them
specifically using \code{specific_args}.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
A \link{list} with:
\itemize{
\item \code{SummaryTable}: \link{data.frame} containing data quality checks for
"Unexpected location" (\code{FLG_acc_ud_loc}) and "Unexpected
proportion" (\code{FLG_acc_ud_prop}) for each response
variable in \code{resp_vars}.
\item \code{SummaryData}: a \link{data.frame} containing data quality checks for
"Unexpected location" and / or "Unexpected proportion"
for a report
\item \code{SummaryPlotList}: \link{list} of \link[ggplot2:ggplot]{ggplot2::ggplot}s for each response variable in
\code{resp_vars}.
}
}
\description{
Data quality indicator checks "Unexpected location" and "Unexpected
proportion" with histograms.

\link{Indicator}
}
\section{Algorithm of this implementation:}{
\itemize{
\item If no response variable is defined, select all variables of type float or
integer in the study data.
\item Remove missing codes from the study data (if defined in the metadata).
\item Remove measurements deviating from (hard) limits defined in the metadata
(if defined).
\item Exclude variables containing only \code{NA} or only one unique value (excluding
\code{NA}s).
\item Perform check for "Unexpected location" if defined in the metadata (needs a
LOCATION_METRIC (mean or median) and LOCATION_RANGE (range of expected values
for the mean and median, respectively)).
\item Perform check for "Unexpected proportion" if defined in the metadata (needs
PROPORTION_RANGE (range of expected values for the proportions of the
categories)).
\item Plot histogram(s).
}
}

\seealso{
\itemize{
\item \link{acc_distributions}
\item \href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_distributions.html}{Online Documentation}
}
}
