% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_stats_dm.R
\name{summary.stats_dm}
\alias{summary.stats_dm}
\alias{summary.basic_stats}
\alias{summary.cafs}
\alias{summary.quantiles}
\alias{summary.delta_funs}
\alias{summary.fit_stats}
\alias{summary.sum_dist}
\alias{summary.stats_dm_list}
\alias{print.summary.stats_dm}
\alias{print.summary.basic_stats}
\alias{print.summary.cafs}
\alias{print.summary.quantiles}
\alias{print.summary.delta_funs}
\alias{print.summary.fit_stats}
\alias{print.summary.sum_dist}
\alias{print.summary.stats_dm_list}
\title{Summary for \code{stats_dm} Objects}
\usage{
\method{summary}{stats_dm}(object, ..., round_digits = drift_dm_default_rounding())

\method{summary}{basic_stats}(object, ...)

\method{summary}{cafs}(object, ...)

\method{summary}{quantiles}(object, ...)

\method{summary}{delta_funs}(object, ...)

\method{summary}{fit_stats}(object, ...)

\method{summary}{sum_dist}(object, ...)

\method{summary}{stats_dm_list}(object, ...)

\method{print}{summary.stats_dm}(x, ..., show_header = TRUE, drop_cols = NULL)

\method{print}{summary.basic_stats}(x, ...)

\method{print}{summary.cafs}(x, ...)

\method{print}{summary.quantiles}(x, ...)

\method{print}{summary.delta_funs}(x, ...)

\method{print}{summary.fit_stats}(x, ...)

\method{print}{summary.sum_dist}(x, ...)

\method{print}{summary.stats_dm_list}(x, ...)
}
\arguments{
\item{object}{an object of the respective class}

\item{...}{additional arguments passed forward.}

\item{round_digits}{integer, specifying the number of decimal places for
rounding the summary of the underlying \link{data.frame}. Default is 3.}

\item{x}{an object of the respective class.}

\item{show_header}{logical. If \code{TRUE}, a header specifying the type of
statistic will be displayed.}

\item{drop_cols}{character vector, specifying which columns
of the table summarizing the underlying \link{data.frame} should not be
displayed.}
}
\value{
For \verb{summary.*()} methods, a summary object of class corresponding to the
input class.

For \verb{print.*()} methods, the respective object is returned invisibly
}
\description{
Summary and corresponding printing methods for objects of the classes
\code{stats_dm}, \code{basic_stats}, \code{cafs}, \code{quantiles}, \code{delta_funs}, \code{fit_stats},
\code{sum_dist}, and \code{stats_dm_list}. These object types result from a call to
\code{\link[=calc_stats]{calc_stats()}}.
}
\details{
\itemize{
\item \code{summary.stats_dm()}: Summarizes \code{stats_dm} objects, returning the type,
a summary of the underlying \link{data.frame} (\code{summary_dataframe}), and, if
possible, the number of unique IDs (\code{n_ids}).
\item \code{summary.sum_dist()}: Extends \code{summary.stats_dm()} with additional
information about the source (\code{source}).
\item \code{summary.basic_stats()}: Extends \code{summary.sum_dist()} with additional
information about the conditions (\code{conds}).
\item \code{summary.cafs()}: Extends \code{summary.sum_dist()} with additional information
about the bins (\code{bins}) and conditions (\code{conds}).
\item \code{summary.quantiles()}: Extends \code{summary.sum_dist()} with additional
information about the quantile levels (\code{probs}) and conditions (\code{conds}).
\item \code{summary.delta_funs()}: Extends \code{summary.sum_dist()} with additional
information about the quantile levels (\code{probs}).
\item \code{summary.fit_stats()}: Identical to \code{summary.stats_dm}.
\item \code{summary.stats_dm_list()}: Applies the summary function to each element of
the list and returns a list of the respective summary objects.
}

Note the following class relationships and properties:
\itemize{
\item \code{basic_stats}, \code{cafs}, \code{quantiles}, and \code{delta_funs} are all inheriting
from \code{sum_dist}.
\item All \code{sum_dist} and \code{fit_stats} objects are inheriting from
\code{stats_dm}.
\item Each \code{stats_dm_list} object is just a list containing instances of
\code{stats_dm}.
}
}
\examples{
# get a model with data for demonstration purpose
a_model <- dmc_dm()
obs_data(a_model) <- dmc_synth_data

# now get some statistics and call the summary functions
some_stats <- calc_stats(a_model, type = c("quantiles", "fit_stats"))
summary(some_stats) # summary.stats_dm_list
summary(some_stats$quantiles) # summary.quantiles

}
