% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.densities}
\alias{plot.densities}
\title{Plot Distributions of Predicted and Observed Data}
\usage{
\method{plot}{densities}(
  x,
  ...,
  id = NULL,
  conds = NULL,
  col = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "RT [s]",
  ylab = "Density",
  obs_stats = "hist",
  interval_obs = FALSE,
  interval_pred = TRUE
)
}
\arguments{
\item{x}{an object of \code{type = "densities"}, typically returned by
\code{\link[=calc_stats]{calc_stats()}}.}

\item{...}{additional graphical arguments passed to plotting functions.
See \code{\link[=set_default_arguments]{set_default_arguments()}} for the full list of supported
options.}

\item{id}{a numeric or character, specifying the ID of a single participant
to plot. If \code{length(id) > 1}, \code{plot.cafs()} is called recursively for
each entry. Each \code{id} must match an entry in the \code{ID} column of \code{x}.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{col}{a character vector specifying colors for each condition. If a
single color is provided, it is repeated for all conditions.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{ylim}{a numeric vector of length 2, specifying the y-axis limits.}

\item{xlab, ylab}{character strings for the x- and y-axis labels.}

\item{obs_stats}{a character vector specifying which observed statistics to
plot. Options include \code{"hist"} for histograms and \code{"kde"} for kernel
density estimates. Defaults to \code{"hist"}.}

\item{interval_obs, interval_pred}{logicals; if \code{TRUE} and \code{x} contains a
column named \code{Estimate}, error bars for observed data and shaded contours
for predicted data are drawn, respectively.}
}
\value{
Returns \code{NULL} invisibly. The function is called for its side effect of
generating a plot.
}
\description{
Visualizes observed and/or predicted response time distributions. Useful for
assessing model fit or exploring model behavior.
}
\details{
If \code{x} contains multiple \code{ID}s and no specific \code{id} is provided, the function
aggregates across participants before plotting. You can provide a vector of
\code{id}s to produce separate plots for each participant.

Observed densities are shown as histograms (default: gray shaded areas), or
KDE lines (default: black, dotted). Predicted densities are shown as lines
(default: colorized). Distributions associated with the upper boundary are
shown with values > 0 (i.e., the upper part of the plot), distributions
associated with the lower boundary are shown with values < 0 (i.e., the lower
part of the plot).

Axis limits, colors, and styling options can be customized via \code{...}. If
interval information is provided (i.e., the column \code{Estimate} exists in \code{x}),
error bars or shading will be added, depending on the type of
statistic.

A legend is only displayed if there is predicted data.
}
\examples{
# Example 1: Predicted densities only -------------------------------------
a_model <- dmc_dm()
dens <- calc_stats(a_model, type = "densities")
plot(dens, xlim = c(0, 1))
plot(dens, xlim = c(0, 1), conds = "comp")


# Example 2: Observed and predicted densities -----------------------------
obs_data(a_model) <- dmc_synth_data
dens <- calc_stats(a_model, type = "densities")
plot(dens, xlim = c(0, 1), conds = "comp", col = "blue")

# Example 3: Observed densities only --------------------------------------
dens <- calc_stats(dmc_synth_data, type = "densities")
plot(dens, conds = "comp", obs.hist.col = "green", alpha = 1)

# Example 4: With interval estimates --------------------------------------
dens <- calc_stats(dmc_synth_data, type = "densities", resample = TRUE)
plot(dens, interval_obs = TRUE, conds = "comp")

}
