% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_ez_diffusion}
\alias{get_ez_diffusion}
\title{Compute EZ Diffusion parameters}
\usage{
get_ez_diffusion(drift_dm_obj)
}
\arguments{
\item{drift_dm_obj}{a drift diffusion model object containing observed data
in \code{obs_data}, including upper (\code{rts_u}) and lower (\code{rts_l}) response times
per condition}
}
\value{
a matrix with rows \code{muc}, \code{b}, and \code{non_dec}
}
\description{
Internal helper that computes EZ diffusion model parameters for each
condition in a \code{drift_dm_obj}. The computation is based on the equations
from Wagenmakers et al. (2007) and estimates drift rate (\code{muc}), boundary
separation (\code{b}), and non-decision time (\code{non_dec}).
}
\details{
If \code{Pc} equals 0, 0.5, or 1, small adjustments are applied to prevent
numerical issues in the logit transformation.
}
\keyword{internal}
