% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_list}
\alias{cvd_indicator_list}
\title{List available indicators for a system level and time period}
\usage{
cvd_indicator_list(time_period_id, system_level_id)
}
\arguments{
\item{time_period_id}{Integer (required). The reporting period (time period) for which to return indicators. Use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to find valid IDs.}

\item{system_level_id}{Integer (required). The system level (e.g., National, Region, ICB, PCN, Practice) for which to return indicators. Use \code{\link[=cvd_area_system_level]{cvd_area_system_level()}} to find valid IDs for a given time period.}
}
\value{
A tibble with one row per available indicator for the specified system level and time period. Typical columns include:
\describe{
\item{AxisCharacter}{Character. Symbol used to represent the metric axis (e.g., "\%").}
\item{DataUpdateInterval}{Character. Frequency or interval at which the indicator data is updated. Often blank.}
\item{FormatDisplayName}{Character. Display format for the metric (e.g., "Proportion \%").}
\item{HighestPriorityNotificationType}{Character. Notification priority level, if applicable (e.g., "Red"). Often blank.}
\item{IndicatorCode}{Character. Unique code for the indicator (e.g., "CVDP005CKD").}
\item{IndicatorFormatID}{Integer. Internal ID for the indicator's format type.}
\item{IndicatorID}{Integer. Unique identifier for the indicator.}
\item{IndicatorName}{Character. Full descriptive name of the indicator.}
\item{IndicatorOrder}{Integer. Display order for the indicator in dashboards or reports.}
\item{IndicatorShortName}{Character. Abbreviated name of the indicator for display purposes.}
\item{IndicatorStatus}{Character. Status of the indicator (e.g., active, retired). Often blank.}
\item{NotificationCount}{Integer. Count of notifications associated with the indicator.}
}
If no indicators are found, returns a tibble describing the error.
}
\description{
Retrieves basic details for all CVD indicators available for a given system level and reportion period from the CVDPREVENT API. Only indicators with data for the selected time period and system level are returned. This function is commonly used to populate indicator pickers or to discover what data is available for further queries.
}
\details{
Use this function to discover which indicators are available for a specific combination of system level and time period. The results can be joined with other outputs for further analysis, or used as the basis for more detailed indicator, metric, or data queries.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Docuemtnation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2Flist}{CVDPREVENT API documentation: Indicator list}
}

\examples{
\donttest{
# List four indicators for time period 17 and GP practice level (system level 5)
cvd_indicator_list(time_period_id = 17, system_level_id = 5) |>
  dplyr::select(IndicatorID, IndicatorCode, IndicatorShortName) |>
  dplyr::slice_head(n = 4)

# Find valid time period and system level IDs, then list all available indicators
valid_periods <- cvd_time_period_list()
valid_levels <- cvd_area_system_level(time_period_id = 17)
cvd_indicator_list(time_period_id = 17, system_level_id = valid_levels$SystemLevelID[1])
}

}
\seealso{
\code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}}, \code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}}, \code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}}, \code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}}, \code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, \code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}}, \code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}}, \code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
