% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_dataset_list.R
\name{cto_dataset_list}
\alias{cto_dataset_list}
\title{List Available Server Datasets}
\usage{
cto_dataset_list(
  order_by = "createdOn",
  sort = c("ASC", "DESC"),
  team_id = NULL
)
}
\arguments{
\item{order_by}{String. The field to sort the results by. Options are:
\code{"id"}, \code{"title"}, \code{"createdOn"}, \code{"modifiedOn"}, \code{"status"}, \code{"version"},
or \code{"discriminator"}. Defaults to \code{"createdOn"}.}

\item{sort}{String. The direction of the sort: \code{"asc"} (ascending) or
\code{"desc"} (descending). Defaults to \code{"asc"}.}

\item{team_id}{String (Optional). Filter datasets by a specific Team ID.
If provided, only datasets accessible to that team are returned.
Example: \code{'team-456'}.}
}
\value{
A data frame containing the metadata of available datasets.
}
\description{
Retrieves a list of datasets that the authenticated user has access to.
Results can be filtered by team and ordered by specified fields.
}
\examples{
\dontrun{
# List all datasets sorted by creation date
ds_list <- cto_dataset_list()

# List datasets for a specific team, ordered by title
team_ds <- cto_dataset_list(team_id = "team-123", order_by = "title")
}
}
\seealso{
Other Dataset Management Functions: 
\code{\link{cto_dataset_create}()},
\code{\link{cto_dataset_delete}()},
\code{\link{cto_dataset_download}()},
\code{\link{cto_dataset_info}()}
}
\concept{Dataset Management Functions}
