% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_dataset_delete.R
\name{cto_dataset_delete}
\alias{cto_dataset_delete}
\alias{cto_dataset_purge}
\title{Delete or Purge a Dataset}
\usage{
cto_dataset_delete(id)

cto_dataset_purge(id)
}
\arguments{
\item{id}{String. The unique identifier of the dataset.}
}
\value{
A list confirming the operation status.
}
\description{
Functions to permanently remove data from the server.
\itemize{
\item \code{cto_delete_dataset()}: \strong{Permanently deletes} a dataset and all its associated data.
This operation cannot be undone
\item \code{cto_purge_dataset()}: Removes \strong{all records} from the dataset but
keeps the dataset definition (schema/ID) intact.
}
}
\examples{
\dontrun{
# 1. Delete dataset
cto_dataset_delete(id = "hh_data")

# 2. Purge dataset
cto_dataset_purge(id = "hh_data")
}
}
\seealso{
Other Dataset Management Functions: 
\code{\link{cto_dataset_create}()},
\code{\link{cto_dataset_download}()},
\code{\link{cto_dataset_info}()},
\code{\link{cto_dataset_list}()}
}
\concept{Dataset Management Functions}
