% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{GeneralSimulations-class}
\alias{GeneralSimulations-class}
\alias{.GeneralSimulations}
\alias{GeneralSimulations}
\alias{.DefaultGeneralSimulations}
\title{\code{GeneralSimulations}}
\usage{
GeneralSimulations(data, doses, seed)

.DefaultGeneralSimulations()
}
\arguments{
\item{data}{(\code{list})\cr see slot definition.}

\item{doses}{(\code{numeric})\cr see slot definition.}

\item{seed}{(\code{integer})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This class captures trial simulations.
Here also the random generator state before starting the simulation is
saved, in order to be able to reproduce the outcome. For this just use
\code{\link{set.seed}} with the \code{seed} as argument before running
\code{\link{simulate,Design-method}}.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{list})\cr produced \code{\link{Data}} objects.}

\item{\code{doses}}{(\code{numeric})\cr final dose recommendations.}

\item{\code{seed}}{(\code{integer})\cr random generator state before starting the simulation.}
}}

\note{
Typically, end users will not use the \code{.DefaultGeneralSimulations()} function.
}
\examples{
data <- list(
  Data(x = 1:3, y = c(0, 1, 0), doseGrid = 1:3, ID = 1L:3L, cohort = 1L:3L),
  Data(x = 4:6, y = c(0, 1, 0), doseGrid = 4:6, ID = 1L:3L, cohort = 1L:3L)
)

doses <- c(1, 2)

seed <- 123L

simulations <- GeneralSimulations(data, doses, seed)
}
