% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rules.R
\name{h_next_best_mg_doses_at_grid}
\alias{h_next_best_mg_doses_at_grid}
\title{Get Closest Grid Doses for a Given Target Doses for \code{nextBest-NextBestMaxGain} Method.}
\usage{
h_next_best_mg_doses_at_grid(
  dose_target_drt,
  dose_target_eot,
  dose_mg,
  dose_grid,
  doselimit,
  placebo
)
}
\arguments{
\item{dose_target_drt}{(\code{number})\cr target dose estimate during the trial.}

\item{dose_target_eot}{(\code{number})\cr target dose estimate at the end of the trial.}

\item{dose_mg}{(\code{number})\cr the dose corresponding to the maximum gain.}

\item{dose_grid}{(\code{numeric})\cr all possible doses.}

\item{doselimit}{(\code{number})\cr the maximum allowed next dose.}

\item{placebo}{(\code{flag})\cr if \code{TRUE} the first dose level in the \code{dose_grid}
is considered as placebo.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function that for a given target doses finds the dose in grid that is
closest and below the target. There are four different targets in the context
of \code{\link[=nextBest-NextBestMaxGain]{nextBest-NextBestMaxGain()}} method: \eqn{min(`dose_mg`, `dose_target_drt`)},
\code{dose_mg}, \code{dose_target_drt} or \code{dose_target_eot}.
}
