% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_df}
\alias{example_df}
\title{Example assignment problem data frame}
\format{
A tibble with 18 rows and 4 columns:
\describe{
\item{sim}{Simulation/problem identifier. Integer with values 1 or 2,
distinguishing two independent assignment problems. Use with
\code{group_by(sim)} for grouped solving.}
\item{source}{Source node index. Integer 1-3 representing the row
(source) in each 3x3 cost matrix.}
\item{target}{Target node index. Integer 1-3 representing the column
(target) in each 3x3 cost matrix.}
\item{cost}{Cost of assigning source to target. Numeric values ranging
from 1-7. Each source-target pair has exactly one cost entry.}
}
}
\usage{
example_df
}
\description{
A tidy data frame representation of assignment problems, suitable for
use with grouped workflows and batch solving. Contains two independent
3x3 assignment problems in long format.
}
\details{
This dataset demonstrates couplr's data frame interface for LAP solving.
The long format (one row per source-target pair) is converted internally
to a cost matrix for solving.

\strong{Simulation 1}: Costs from \code{example_costs$simple_3x3}
\itemize{
\item Optimal assignment: (1->2, 2->1, 3->3)
\item Total cost: 9
}

\strong{Simulation 2}: Different cost structure
\itemize{
\item Optimal assignment: (1->1, 2->3, 3->3) or equivalent
\item Total cost: 4
}
}
\examples{
library(dplyr)

# Solve both problems with grouped workflow
example_df |>
  group_by(sim) |>
  lap_solve(source, target, cost)

# Batch solving for efficiency
example_df |>
  group_by(sim) |>
  lap_solve_batch(source, target, cost)

# Inspect the data structure
example_df |>
  group_by(sim) |>
  summarise(
    n_pairs = n(),
    min_cost = min(cost),
    max_cost = max(cost)
  )

}
\seealso{
\code{\link{lap_solve}}, \code{\link{lap_solve_batch}},
\code{\link{example_costs}}
}
\keyword{datasets}
