% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_matrix.R
\name{cor_matrix}
\alias{cor_matrix}
\title{Signed pairwise correlation matrix}
\usage{
cor_matrix(df = NULL, predictors = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with predictors or the output of \code{\link[=cor_df]{cor_df()}}. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
correlation matrix
}
\description{
Computes a square matrix of pairwise correlations for a set of numeric and/or categorical predictors.

If \code{df} is already a correlation dataframe generated by \code{\link[=cor_df]{cor_df()}}), the function transforms it into a correlation matrix. Otherwise, \code{\link[=cor_df]{cor_df()}} is used internally to compute pairwise correlations before generating the matrix.

Supports parallel computation via \code{future::plan()} and optional progress reporting via \code{progressr::handlers()}.
}
\examples{
data(vi_smol)

## OPTIONAL: parallelization setup
## irrelevant when all predictors are numeric
## only worth it for large data with many categoricals
# future::plan(
#   future::multisession,
#   workers = future::availableCores() - 1
# )

## OPTIONAL: progress bar
# progressr::handlers(global = TRUE)

predictors <- c(
  "koppen_zone", #character
  "soil_type", #factor
  "topo_elevation", #numeric
  "soil_temperature_mean" #numeric
)

#from dataframe with predictors
x <- cor_matrix(
  df = vi_smol,
  predictors = predictors
)

x

#from correlation dataframe
x <- cor_df(
  df = vi,
  predictors = predictors
) |>
  cor_matrix()

x

## OPTIONAL: disable parallelization
#future::plan(future::sequential)
}
\seealso{
Other multicollinearity_assessment: 
\code{\link{collinear_stats}()},
\code{\link{cor_clusters}()},
\code{\link{cor_cramer}()},
\code{\link{cor_df}()},
\code{\link{cor_stats}()},
\code{\link{vif}()},
\code{\link{vif_df}()},
\code{\link{vif_stats}()}
}
\author{
Blas M. Benito, PhD
}
\concept{multicollinearity_assessment}
