% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{diagnostic.cor.eigs}
\alias{diagnostic.cor.eigs}
\alias{diagnostic.cor.eigs.default}
\alias{diagnostic.cor.eigs.Seurat}
\title{Determine the dimension of low dimensional embedding}
\usage{
diagnostic.cor.eigs(object, ...)

\method{diagnostic.cor.eigs}{default}(
  object,
  q_max = 50,
  plot = TRUE,
  n.sims = 10,
  parallel = TRUE,
  ncores = 10,
  seed = 1,
  ...
)

\method{diagnostic.cor.eigs}{Seurat}(
  object,
  assay = NULL,
  slot = "data",
  nfeatures = 2000,
  q_max = 50,
  seed = 1,
  ...
)
}
\arguments{
\item{object}{A Seurat or matrix object}

\item{...}{Other arguments passed to \code{\link{diagnostic.cor.eigs.default}}.}

\item{q_max}{the upper bound of low dimensional embedding. Default is 50.}

\item{plot}{a indicator of whether plot eigen values.}

\item{n.sims}{number of simulaton times. Default is 10.}

\item{parallel}{a indicator of whether use parallel analysis.}

\item{ncores}{the number of cores used in parallel analysis. Default is 10.}

\item{seed}{a postive integer, specify the random seed for reproducibility}

\item{assay}{an optional string, specify the name of assay in the Seurat object to be used.}

\item{slot}{an optional string, specify the name of slot.}

\item{nfeatures}{an optional integer, specify the number of features to select as top variable features. Default is 2000.}
}
\value{
A data.frame with attribute `q_est` and `plot`, which is the estimated dimension of low dimensional embedding. In addition, this data.frame containing the following components:
\itemize{
  \item q - The index of eigen values.
  \item eig_value - The eigen values on observed data.
  \item eig_sim - The mean value of eigen values of n.sims simulated data.
  \item q_est - The selected dimension in attr(obj, 'q_est').
  \item plot - The plot saved in attr(obj, 'plot').
}
}
\description{
This function estimate the dimension of low dimensional embedding for a given cell by gene expression matrix. For more details, see Franklin et al. (1995) and Crawford et al. (2010).
}
\examples{
n <- 100
p <- 50
d <- 15
object <- matrix(rnorm(n*d), n, d) \%*\% matrix(rnorm(d*p), d, p)
diagnostic.cor.eigs(object, n.sims=2)
}
\references{
1. Franklin, S. B., Gibson, D. J., Robertson, P. A., Pohlmann, J. T., & Fralish, J. S. (1995). Parallel analysis: a method for determining significant principal components. Journal of Vegetation Science, 6(1), 99-106.

2. Crawford, A. V., Green, S. B., Levy, R., Lo, W. J., Scott, L., Svetina, D., & Thompson, M. S. (2010). Evaluation of parallel analysis methods for determining the number of factors.Educational and Psychological Measurement, 70(6), 885-901.
}
