% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_datasets.R
\name{get_all_differences}
\alias{get_all_differences}
\title{Extract All Differences as a Unified Data Frame}
\usage{
get_all_differences(comparison_results)
}
\arguments{
\item{comparison_results}{A \code{dataset_comparison} or
\code{cdisc_comparison} object, or any list with an
\code{observation_comparison} element.}
}
\value{
A data frame with one row per differing cell. Columns:
\describe{
\item{Variable}{Character: column name where the difference was found.}
\item{Row}{Integer: row index in df1 (positional matching).}
\item{Base}{The value in df1 (base dataset).}
\item{Compare}{The value in df2 (compare dataset).}
\item{Diff}{Numeric: Base - Compare (NA for character columns).}
\item{PctDiff}{Numeric: absolute percentage difference relative to
Base (NA when Base is 0 or column is character).}
}
When key-based matching was used (id_vars), the ID columns are
prepended to the left of the data frame.

Returns an empty data frame with the expected columns when no
differences exist or observation comparison was skipped.
}
\description{
Converts per-variable observation differences into a single long-format
data frame suitable for filtering with dplyr, writing to CSV, or
programmatic analysis. This is the R equivalent of SAS PROC COMPARE's
\code{OUT=} dataset with \code{_TYPE_} and \code{_DIF_} variables.

Accepts output from \code{\link[=compare_datasets]{compare_datasets()}}, \code{\link[=cdisc_compare]{cdisc_compare()}}, or any list
containing an \code{observation_comparison} element with the standard
\code{discrepancies} / \code{details} / \code{id_details} structure.
}
\examples{
\donttest{
df1 <- data.frame(id = 1:3, value = c(10, 20, 30), name = c("A", "B", "C"))
df2 <- data.frame(id = 1:3, value = c(10, 25, 30), name = c("A", "B", "D"))
result <- compare_datasets(df1, df2)
diffs <- get_all_differences(result)
head(diffs)
}
}
