% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_imgw_daily.R
\name{meteo_imgw_daily}
\alias{meteo_imgw_daily}
\title{Daily IMGW meteorological data}
\usage{
meteo_imgw_daily(
  rank = "synop",
  year,
  status = FALSE,
  coords = FALSE,
  station = NULL,
  col_names = "short",
  allow_failure = TRUE,
  ...
)
}
\arguments{
\item{rank}{rank of the stations: "synop" (default), "climate", or "precip"}

\item{year}{vector of years (e.g., 1966:2000)}

\item{status}{leave the columns with measurement and observation statuses
(default status = FALSE - i.e. the status columns are deleted)}

\item{coords}{add coordinates of the station (logical value TRUE or FALSE)}

\item{station}{name of meteorological station(s).
It accepts vector of names (characters in CAPITAL LETTERS);
Important: Some stations may have changed names over time in the IMGW-PIB
database and thus providing both names is needed
(e.g. \code{station = c("POZNAŃ", "POZNAŃ-ŁAWICA", "WARSZAWA", "WARSZAWA-OKĘCIE")}).
Stations' IDs (numeric) are no longer valid}

\item{col_names}{three types of column names possible:
"short" - default, values with shorten names,
"full" - full English description,
"polish" - original names in the dataset}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}

\item{...}{other parameters that may be passed to the 'shortening' function that
shortens column names}
}
\value{
data.frame with a daily meteorological measurements
}
\description{
Downloading daily (meteorological) data from the SYNOP / CLIMATE / PRECIP stations
available in the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
daily = meteo_imgw_daily(rank = "climate", year = 2000)
}

}
