% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runn_mean.R
\name{runn_mean}
\alias{runn_mean}
\title{Running mean of a vector}
\usage{
runn_mean(
  vec,
  runn_mean,
  na.rm = FALSE,
  exclude_central_value = FALSE,
  FUN = mean
)
}
\arguments{
\item{vec}{numeric vector}

\item{runn_mean}{number of vector elements to use for calculating the
running mean}

\item{na.rm}{ignore NA values when calculating means. Defaults to FALSE.}

\item{exclude_central_value}{exclude central value in calculating means.
Defaults to FALSE.}

\item{FUN}{function to be applied. For a running mean, this is usually mean (the
default), but other functions can also be specified here (the na.rm parameter
won't work then, and the function has to be dependent on one numeric variable only.}
}
\value{
numeric vector containing the running mean
}
\description{
Function to calculate the running mean of a numeric vector
}
\examples{


plot(runn_mean(rnorm(1000),150))

}
\author{
Eike Luedeling
}
\keyword{"running}
\keyword{mean"}
