% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{assert_cli}
\alias{assert_cli}
\title{Combine multiple CLI assertions}
\usage{
assert_cli(..., combine = "or", .var.name = NULL, add = NULL)
}
\arguments{
\item{...}{Expressions evaluating to the result of `check_*_cli()` calls.}

\item{combine}{Either `"or"` or `"and"`.}

\item{.var.name}{Optional variable name(s) for the combined assertion.}

\item{add}{Optional [checkmate::AssertCollection] to collect failures.}
}
\value{
Invisible `TRUE` on success, otherwise error or collected failures.
}
\description{
Combine multiple `check_*_cli()` expressions with `"or"` or `"and"`
logic and assert them jointly.
}
\examples{
x <- 1L
assert_cli(
  check_int_cli(x),
  check_numeric_cli(x),
  combine = "or",
  .var.name = "x"
)

}
