% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{validate_input}
\alias{validate_input}
\title{Validate Input Data for Hedonic Index Calculation}
\usage{
validate_input(
  dataset,
  period_variable,
  dependent_variable,
  continuous_variables,
  categorical_variables
)
}
\arguments{
\item{dataset}{A data.frame containing the dataset to be validated.}

\item{period_variable}{A string specifying the name of the period variable column.}

\item{dependent_variable}{A string specifying the name of the dependent variable (usually the sale price).}

\item{continuous_variables}{A character vector with names of numeric quality-determining variables.}

\item{categorical_variables}{A character vector with names of categorical variables (including dummies).}
}
\value{
Returns TRUE invisibly if all checks pass. Otherwise, an error is thrown.
}
\description{
This function checks whether the dataset contains all required variables, whether the dependent and continuous variables are numeric,
and whether the period variable is formatted correctly (e.g., "2020Q1", "2020M01").
It ensures that the data is suitable for further processing in hedonic index calculations.
}
\author{
David Pietersz
}
\keyword{internal}
