% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CARAEE_Sim}
\alias{CARAEE_Sim}
\title{Simulation Function of of CARA Designs Based on Efficiency and Ethics for Binary and Continuous Response.}
\usage{
CARAEE_Sim(n, thetaA, thetaB, m0 = 40, pts.cov, response, gamma)
}
\arguments{
\item{n}{a positive integer. The value specifies the total number of participants involved in each round of the simulation.}

\item{thetaA}{a vector of length \code{k+1}. The true coefficient parameter value for treatment A.}

\item{thetaB}{a vector of length \code{k+1}. The true coefficient parameter value for treatment B.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally for estimation. The default value is 40.}

\item{pts.cov}{a \code{n x k} matrix. The simulated covariate matrix for patients.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}

\item{gamma}{a non-negative number. A tuning parameter that reflects the importance of the efficiency component compared to the ethics component.}
}
\value{
A list with the following elements:
\item{method}{The name of the procedure.}
\item{sampleSize}{Total number of patients.}
\item{parameter}{Estimated parameter values.}
\item{assignment}{Treatment assignment vector.}
\item{proportion}{Proportion of patients allocated to treatment A.}
\item{responses}{Simulated response values.}
\item{failureRate}{Proportion of treatment failures (if \code{response = "Binary"}).}
\item{meanResponse}{Mean response value (if \code{response = "Cont"}).}
\item{rejectNull}{Logical. Indicates whether the treatment effect is statistically significant based on a Wald test.}
}
\description{
This function simulates a clinical trial using CARA Designs Based on Efficiency and Ethics (CARAEE) with Binary or Continuous Responses.
}
\examples{
set.seed(123)
results = CARAEE_Sim(n = 400,
                     pts.cov = cbind(rnorm(400), rnorm(400)),
                     thetaA = c(-1, 1, 1),
                     thetaB = c(3, 1, 1),
                     response = "Binary",
                     gamma=1)
}
\concept{CARAEE Design}
