% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_input_file.R
\name{diagnose_input_file}
\alias{diagnose_input_file}
\title{Diagnose Input File for Data Quality Issues}
\usage{
diagnose_input_file(filename.in)
}
\arguments{
\item{filename.in}{file path, the file containing the 5 years age counts of
cancers stratified per cancer type, sex and country of birth}
}
\value{
A list containing diagnostic information:
\itemize{
\item duplicate_age_groups: Data frame of combinations with duplicate age groups
\item invalid_age_groups: Character vector of invalid age group labels found
\item summary: Overall summary of issues found
}
}
\description{
This function checks the input file for common data quality issues that can
cause errors during processing, including duplicate age groups and unexpected
age group labels.
}
\examples{
\donttest{
  file.in <- system.file("extdata", "ex_cancerRADAR_input_filled.xlsx",
                         package = "cancerradarr")
  diagnosis <- diagnose_input_file(file.in)
  print(diagnosis$summary)
}
}
