% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var-bayes.R, R/print-bvharsp.R
\name{var_bayes}
\alias{var_bayes}
\alias{print.bvarsv}
\alias{print.bvarldlt}
\alias{knit_print.bvarsv}
\alias{knit_print.bvarldlt}
\title{Fitting Bayesian VAR with Coefficient and Covariance Prior}
\usage{
var_bayes(
  y,
  p,
  exogen = NULL,
  s = 0,
  factor_spec = set_factor(),
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  coef_spec = set_bvar(),
  contem_spec = coef_spec,
  cov_spec = set_ldlt(),
  intercept = set_intercept(),
  exogen_spec = coef_spec,
  loading_spec = coef_spec,
  include_mean = TRUE,
  minnesota = TRUE,
  ggl = TRUE,
  save_init = FALSE,
  convergence = NULL,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{bvarldlt}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvarsv}(x, ...)

\method{knit_print}{bvarldlt}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{exogen}{Unmodeled variables}

\item{s}{Lag of exogeneous variables in VARX(p, s). By default, \code{s = 0}.}

\item{factor_spec}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Factor augmentation specification by \code{\link[=set_factor]{set_factor()}}.}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{coef_spec}{Coefficient prior specification by \code{\link[=set_bvar]{set_bvar()}}, \code{\link[=set_ssvs]{set_ssvs()}}, or \code{\link[=set_horseshoe]{set_horseshoe()}}.}

\item{contem_spec}{Contemporaneous coefficient prior specification by \code{\link[=set_bvar]{set_bvar()}}, \code{\link[=set_ssvs]{set_ssvs()}}, or \code{\link[=set_horseshoe]{set_horseshoe()}}.}

\item{cov_spec}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SV specification by \code{\link[=set_sv]{set_sv()}}.}

\item{intercept}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Prior for the constant term by \code{\link[=set_intercept]{set_intercept()}}.}

\item{exogen_spec}{Exogenous coefficient prior specification.}

\item{loading_spec}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Factor loading prior specification.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). By default, \code{TRUE}.}

\item{ggl}{If \code{TRUE} (default), use additional group shrinkage parameter for group structure.
Otherwise, use group shrinkage parameter instead of global shirnkage parameter.
Applies to HS, NG, and DL priors.}

\item{save_init}{Save every record starting from the initial values (\code{TRUE}).
By default, exclude the initial values in the record (\code{FALSE}), even when \code{num_burn = 0} and \code{thinning = 1}.
If \code{num_burn > 0} or \code{thinning != 1}, this option is ignored.}

\item{convergence}{Convergence threshold for rhat < convergence. By default, \code{NULL} which means no warning.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{Number of threads}

\item{x}{\code{bvarldlt} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{var_bayes()} returns an object named \code{bvarsv} \link{class}.
\describe{
\item{coefficients}{Posterior mean of coefficients.}
\item{chol_posterior}{Posterior mean of contemporaneous effects.}
\item{param}{Every set of MCMC trace.}
\item{param_names}{Name of every parameter.}
\item{group}{Indicators for group.}
\item{num_group}{Number of groups.}
\item{df}{Numer of Coefficients: \verb{3m + 1} or \verb{3m}}
\item{p}{VAR lag}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{VHAR_SSVS_SV}, \code{VHAR_Horseshoe_SV}, or \code{VHAR_minnesota-part_SV}}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{spec}{Coefficients prior specification}
\item{sv}{log volatility prior specification}
\item{intercept}{Intercept prior specification}
\item{init}{Initial values}
\item{chain}{The numer of chains}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
If it is SSVS or Horseshoe:
\describe{
\item{pip}{Posterior inclusion probabilities.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
This function fits BVAR.
Covariance term can be homoskedastic or heteroskedastic (stochastic volatility).
It can have Minnesota, SSVS, and Horseshoe prior.
}
\details{
Cholesky stochastic volatility modeling for VAR based on
\deqn{\Sigma_t^{-1} = L^T D_t^{-1} L},
and implements corrected triangular algorithm for Gibbs sampler.
}
\references{
Carriero, A., Chan, J., Clark, T. E., & Marcellino, M. (2022). \emph{Corrigendum to “Large Bayesian vector autoregressions with stochastic volatility and non-conjugate priors” [J. Econometrics 212 (1)(2019) 137-154]}. Journal of Econometrics, 227(2), 506-512.

Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.

Cogley, T., & Sargent, T. J. (2005). \emph{Drifts and volatilities: monetary policies and outcomes in the post WWII US}. Review of Economic Dynamics, 8(2), 262-302.

Gruber, L., & Kastner, G. (2022). \emph{Forecasting macroeconomic data with Bayesian VARs: Sparse or dense? It depends!} arXiv.

Huber, F., Koop, G., & Onorante, L. (2021). \emph{Inducing Sparsity and Shrinkage in Time-Varying Parameter Models}. Journal of Business & Economic Statistics, 39(3), 669-683.

Korobilis, D. (2022). A new algorithm for structural restrictions in Bayesian vector autoregressions. European Economic Review, 148, 104241.

Korobilis, D., & Shimizu, K. (2022). \emph{Bayesian Approaches to Shrinkage and Sparse Estimation}. Foundations and Trends® in Econometrics, 11(4), 230-354.

Ray, P., & Bhattacharya, A. (2018). \emph{Signal Adaptive Variable Selector for the Horseshoe Prior}. arXiv.
}
