% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-pkg-devtools.R
\name{btw_tool_pkg_check}
\alias{btw_tool_pkg_check}
\title{Tool: Run R CMD check on a package}
\usage{
btw_tool_pkg_check(pkg = ".", `_intent` = "")
}
\arguments{
\item{pkg}{Path to package directory. Defaults to '.'. Must be within
current working directory.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
The output from \code{\link[devtools:check]{devtools::check()}}.
}
\description{
Run R CMD check on a package using \code{\link[devtools:check]{devtools::check()}}. This performs
comprehensive checks on the package structure, code, and documentation.
}
\details{
The check runs with \code{remote = TRUE}, \code{cran = TRUE}, \code{manual = FALSE}, and
\code{error_on = "never"} to provide comprehensive feedback without failing.
}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other pkg tools: 
\code{\link{btw_tool_pkg_coverage}()},
\code{\link{btw_tool_pkg_document}()},
\code{\link{btw_tool_pkg_test}()}
}
\concept{pkg tools}
