% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series-database.R
\docType{data}
\name{br_available_series}
\alias{br_available_series}
\title{Brazilian Economic Series Database}
\format{
A tibble with multiple rows and the following columns:
\describe{
\item{series_id}{SGS code from Central Bank of Brazil}
\item{source}{Data source}
\item{source_system}{Source system}
\item{short_name}{Short name of the series}
\item{long_name_pt}{Full name in Portuguese}
\item{long_name_en}{Full name in English}
\item{description_pt}{Description in Portuguese}
\item{description_en}{Description in English}
\item{category_pt}{Category in Portuguese}
\item{category_en}{Category in English}
\item{sub_category_pt}{Sub-category in Portuguese}
\item{sub_category_en}{Sub-category in English}
\item{frequency}{Data frequency}
\item{unit}{Measurement unit}
\item{seasonally_adjusted}{Logical}
\item{start_date}{Series start date}
\item{end_date}{Series end date}
\item{default_transform}{Suggested transformation}
\item{suggested_scale}{Suggested visualization scale}
\item{notes_pt}{Notes in Portuguese}
\item{notes_en}{Notes in English}
}
}
\source{
Central Bank of Brazil — SGS
}
\usage{
br_available_series
}
\description{
A comprehensive database of Brazilian economic and financial time series
available through the Central Bank of Brazil's SGS system.
}
\examples{
br_available_series

br_available_series[br_available_series$series_id == "433", ]

br_available_series[br_available_series$series_id == "433", ]
}
\keyword{datasets}
