% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel_functions.R
\name{hankel_functions}
\alias{hankel_functions}
\alias{cyl_hankel_1}
\alias{cyl_hankel_2}
\alias{sph_hankel_1}
\alias{sph_hankel_2}
\title{Hankel Functions}
\usage{
cyl_hankel_1(v, x)

cyl_hankel_2(v, x)

sph_hankel_1(v, x)

sph_hankel_2(v, x)
}
\arguments{
\item{v}{Order of the Hankel function}

\item{x}{Argument of the Hankel function}
}
\value{
A single complex value with the computed Hankel function.
}
\description{
Functions to compute cyclic and spherical Hankel functions of the first and second kinds.
}
\examples{
cyl_hankel_1(2, 0.5)
cyl_hankel_2(2, 0.5)
sph_hankel_1(2, 0.5)
sph_hankel_2(2, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/hankel.html}{Boost Documentation} for more details on the mathematical background.
}
