% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{destination_flow}
\alias{destination_flow}
\title{Compute the flows incoming at each destination location}
\usage{
destination_flow(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{...}{additional parameters}
}
\value{
a vector of flows incoming at destination locations
}
\description{
Compute the flows incoming at each destination location
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- log(french_cities$population[1:10])
attractiveness <- log(french_cities$area[1:10])
model <- static_blvim(distances, production, 1.5, 1 / 250, attractiveness)
destination_flow(model)
## should be different from the attractiveness as the model is static
attractiveness(model)
}
\seealso{
\code{\link[=production]{production()}}, \code{\link[=attractiveness]{attractiveness()}}
}
