% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioacoustics.R
\docType{package}
\name{bioacoustics-package}
\alias{bioacoustics}
\alias{bioacoustics-package}
\title{bioacoustics: detect and extract automatically acoustic features in Zero-Crossing files and audio recordings}
\description{
bioacoustics contains all the necessary functions to read Zero-Crossing files and audio recordings of various formats,
filter noisy files, display audio signals, detect and extract automatically acoustic features
for further analysis such as species identification based on classification of animal vocalizations.
}
\details{
bioacoustics is subdivided into three main components:

\itemize{
\item Read, write and manipulate acoustic recordings.
\item Display what's inside acoustic recordings, whether to plot or just extract metadata.
\item Analyse audio recordings in batch in search of specific vocalizations and extract acoustic features.
}

To learn more about bioacoustics, start with the introduction vignette:
`vignette("introduction", package = "bioacoustics")`
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wavx/bioacoustics/}
  \item Report bugs at \url{https://github.com/wavx/bioacoustics/issues/}
}

}
\author{
\strong{Maintainer}: Jean Marchal \email{jean.marchal@wavx.ca}

Authors:
\itemize{
  \item Francois Fabianek \email{francois.fabianek@wavx.ca}
  \item Christopher Scott
}

Other contributors:
\itemize{
  \item Chris Corben \email{chris@hoarybat.com} (Read ZC files, original C code) [contributor, copyright holder]
  \item David Riggs \email{driggs@myotisoft.com} (Read GUANO metadata, original R code) [contributor, copyright holder]
  \item Peter Wilson \email{peter@peterwilson.id.au} (Read ZC files, original R code) [contributor, copyright holder]
  \item  Wildlife Acoustics, inc. (Read WAC files, original C code) [contributor, copyright holder]
  \item Jordan Biserkov [contributor]
  \item  WavX, inc. [copyright holder]
}

}
