% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_audit.R
\name{plot_time_acf}
\alias{plot_time_acf}
\title{Plot ACF of test predictions for time-series leakage checks}
\usage{
plot_time_acf(fit, lag.max = 20)
}
\arguments{
\item{fit}{LeakFit.}

\item{lag.max}{maximum lag to show.}
}
\value{
A list with the autocorrelation results, \code{lag.max}, and a ggplot object.
}
\description{
Uses the autocorrelation function of out-of-fold predictions to detect
temporal dependence that may indicate leakage. Predictions are ordered by
the split time column before computing the ACF. Requires numeric predictions
(regression or survival). Requires ggplot2.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(42)
  df <- data.frame(
    id = 1:30,
    time = seq.Date(as.Date("2020-01-01"), by = "day", length.out = 30),
    y = rnorm(30),
    x1 = rnorm(30),
    x2 = rnorm(30)
  )
  splits <- make_split_plan(df, outcome = "y", mode = "time_series",
                            time = "time", v = 3, progress = FALSE)
  custom <- list(
    lm = list(
      fit = function(x, y, task, weights, ...) {
        stats::lm(y ~ ., data = data.frame(y = y, x))
      },
      predict = function(object, newdata, task, ...) {
        as.numeric(stats::predict(object, newdata = as.data.frame(newdata)))
      }
    )
  )
  fit <- fit_resample(df, outcome = "y", splits = splits,
                      learner = "lm", custom_learners = custom,
                      metrics = "rmse", refit = FALSE, seed = 1)
  plot_time_acf(fit, lag.max = 10)
}

}
