% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidsio.R
\name{create_preproc_mask.bids_project}
\alias{create_preproc_mask.bids_project}
\title{Create a binary brain mask from preprocessed scans}
\usage{
\method{create_preproc_mask}{bids_project}(
  x,
  subid,
  thresh = 0.99,
  task = ".*",
  space = ".*",
  mask_kinds = c("brainmask", "mask"),
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object with fMRIPrep derivatives.}

\item{subid}{Regular expression to match subject IDs (e.g., \code{"01"} for
subject 01, \code{".*"} for all subjects).}

\item{thresh}{Threshold value between 0 and 1 (default 0.99). Voxels below
this value in the averaged mask are excluded. Higher values produce more
conservative masks.}

\item{task}{Regular expression for task filtering. Defaults to \code{".*"}
(any task). Because functional masks always carry a \code{task} entity,
this also implicitly excludes anatomical masks which lack it.}

\item{space}{Regular expression for output-space filtering (e.g.,
\code{"MNI152NLin2009cAsym"}). Defaults to \code{".*"} (all spaces).
When masks from multiple spaces are found the function stops with an error
because their dimensions are incompatible.}

\item{mask_kinds}{Character vector of BIDS suffixes to search. Defaults to
both \code{"brainmask"} (older fMRIPrep) and \code{"mask"} with
\code{desc="brain"} (fMRIPrep >= 21).}

\item{...}{Additional arguments passed to \code{search_files} for finding
mask files (e.g., \code{session}, \code{run}).}
}
\value{
A logical mask volume (\code{LogicalNeuroVol}) suitable for use with
preprocessed functional data.
}
\description{
This function creates a binary brain mask from preprocessed functional scans
in a BIDS project. It searches for BOLD brain mask files in the fMRIPrep
derivatives directory (i.e., files in the \code{func/} folder matching the
pattern \code{*_desc-brain_mask.nii.gz} or the older \code{*_brainmask.nii.gz}),
reads them with neuroim2, averages them, and thresholds the result to produce
a consensus binary mask.
}
\details{
The search is restricted to \strong{functional} brain masks by requiring the
\code{task} BIDS entity (anatomical masks do not carry \code{task}).
When masks from multiple output spaces are discovered the function raises an
error; pass a specific \code{space} value to disambiguate.
}
\examples{
\donttest{
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep=TRUE)

  # Mask for one subject in a specific space
  mask <- create_preproc_mask(proj, subid="01",
                              space="MNI152NLin2009cAsym")

  # Consensus mask across all subjects / runs
  all_mask <- create_preproc_mask(proj, subid=".*",
                                  space="MNI152NLin2009cAsym")

  # Restrict to a single task
  task_mask <- create_preproc_mask(proj, subid=".*",
                                  task="balloonanalogrisktask",
                                  space="MNI152NLin2009cAsym")

  unlink(ds_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires derivatives dataset: ", e$message)
})
}

}
