% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R, R/mock_bids.R
\name{build_subject_graph}
\alias{build_subject_graph}
\alias{build_subject_graph.bids_project}
\alias{build_subject_graph.mock_bids_project}
\title{Build Subject Graph Structure}
\usage{
build_subject_graph(x, subid, session = ".*", flatten = FALSE, ...)

\method{build_subject_graph}{bids_project}(x, subid, session = ".*", flatten = FALSE, ...)

\method{build_subject_graph}{mock_bids_project}(x, subid, session = ".*", flatten = FALSE, ...)
}
\arguments{
\item{x}{A \code{bids_project} or \code{mock_bids_project} object.}

\item{subid}{Subject identifier (with or without \verb{sub-} prefix).}

\item{session}{Optional session filter. Default \code{".*"} matches all sessions.}

\item{flatten}{Logical. If \code{FALSE} (default), return a nested list structure.
If \code{TRUE}, return a flat tibble with columns for file_type and metadata.}

\item{...}{Additional arguments passed to underlying query functions.}
}
\value{
If \code{flatten = FALSE} (default), a named list with class \code{bids_subject_graph}:
\describe{
\item{subid}{Subject identifier (without "sub-" prefix)}
\item{sessions}{Character vector of available sessions}
\item{epi}{Named list of preprocessed EPI file paths, keyed by task.run}
\item{anat}{List with t1w and masks sublists}
\item{transforms}{Named list of transform files, keyed by from_to_to format}
\item{surfaces}{Nested list by space, then hemisphere (L/R)}
\item{confounds}{Character vector of confound file paths}
}

If \code{flatten = TRUE}, a tibble with columns:
\describe{
\item{file_type}{Type of file (epi, anat, transform, surface, confound)}
\item{path}{File path}
\item{subid, session, task, run, space, hemi, from, to}{BIDS metadata}
}
}
\description{
Creates a structured list or tibble containing all available data for a single
subject, organized by data type. This provides a comprehensive view of all
available files for a subject, useful for batch processing and pipeline ingestion.
}
\examples{
\donttest{
# Build subject graph
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep = TRUE)

  # Get nested structure
  graph <- build_subject_graph(proj, "01")
  names(graph)

  # Get flat tibble
  flat <- build_subject_graph(proj, "01", flatten = TRUE)
  head(flat)

  # Clean up
  unlink(ds_path, recursive = TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
