% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{getPriorParameters}
\alias{getPriorParameters}
\title{getPriorParameters}
\usage{
getPriorParameters(
  method_names,
  target_rates,
  n_worth = 1,
  tau_scale = 1,
  w_j = 0.5
)
}
\arguments{
\item{method_names}{A vector of strings for the names of the methods to be used.
Available methods: \code{c("berry", "exnex", "exnex_adj", "pooled", "stratified")}}

\item{target_rates}{A vector of numerics in \verb{(0, 1)} for the
target rate of each cohort}

\item{n_worth}{An integer for the number of subjects the variability of the prior should reflect
response rate scale, Default: \code{1}}

\item{tau_scale}{A numeric for the scale parameter of the Half-normal distribution of \eqn{\tau}
in the methods \code{"berry"}, \code{"exnex"}, and \code{"exnex_adj"}, Default: \code{1}}

\item{w_j}{A numeric in \verb{(0, 1)} for the weight of the Ex component in the methods \code{"exnex"}
and \code{"exnex_adj"}, Default: \code{0.5}}
}
\value{
A list with prior parameters of class \code{prior_parameters_list}
}
\description{
This function provides default prior parameters for the analysis methods
that can be used in \code{\link[bhmbasket]{performAnalyses}}.
}
\details{
Regarding the default prior parameters for \code{"berry"}, \code{"exnex"}, and \code{"exnex_adj"}:
\itemize{
\item \code{"berry"}: The mean of \eqn{\mu} is set to \code{0}.
Its variance is calculated as proposed in "Robust exchangeability designs for early
phase clinical trials with multiple strata" (Neuenschwander et al. (2016))
with regard to \code{n_worth}.
The scale parameter of \eqn{\tau} is set to \code{tau_scale}.
\item \code{"exnex"}: The weight of the Ex component is set to \code{w_j}.
For the Ex component:
The target rate that results in the greatest variance is determined.
The mean of \eqn{\mu} is set to that target rate.
The variance of \eqn{\mu} is calculated as proposed in "Robust exchangeability designs for early
phase clinical trials with multiple strata" (Neuenschwander et al. (2016))
with regard to \code{n_worth}.
The scale parameter of \eqn{\tau} is set to \code{tau_scale}.
For the Nex components:
The means of \eqn{\mu_j} are set to the respective target rates.
The variances of \eqn{\tau_j} are calculated as proposed in "Robust exchangeability designs for early
phase clinical trials with multiple strata" (Neuenschwander et al. (2016))
with regard to \code{n_worth}, see also \code{\link[bhmbasket]{getMuVar}}.
\item \code{"exnex_adj"}: The weight of the Ex component is set to \code{w_j}.
For the Ex component:
The target rate that results in the greatest variance is determined.
The mean of \eqn{\mu} is set to \code{0}.
The variance of \eqn{\mu} is calculated as proposed in "Robust exchangeability designs for early
phase clinical trials with multiple strata" (Neuenschwander et al. (2016))
with regard to \code{n_worth}, see also \code{\link[bhmbasket]{getMuVar}}.
The scale parameter of \eqn{\tau} is set to \code{tau_scale}.
For the Nex components:
The means of \eqn{\mu_j} are set to the \code{0}.
The variances of \eqn{\tau_j} are calculated as proposed in "Robust exchangeability designs for early
phase clinical trials with multiple strata" (Neuenschwander et al. (2016))
with regard to \code{n_worth}, see also \code{\link[bhmbasket]{getMuVar}}.
\item \code{"pooled"}: The target rate that results in the greatest variance is determined.
The scale parameter \eqn{\alpha} is set to that target rate times \code{n_worth}.
The scale parameter \eqn{\beta} is set to 1 - that target rate times \code{n_worth}.
\item \code{"stratified"}:
The scale parameters \eqn{\alpha_j} are set to \code{target_rates * n_worth}.
The scale parameters \eqn{\beta_j} are set to \code{(1 - target_rates) * n_worth}.
}
}
\examples{
prior_parameters_list <- getPriorParameters(
  method_names = c("berry", "exnex", "exnex_adj", "pooled", "stratified"),
  target_rates = c(0.1, 0.2, 0.3))
}
\references{
Berry, Scott M., et al. "Bayesian hierarchical modeling of patient subpopulations:
efficient designs of phase II oncology clinical trials."
\emph{Clinical Trials} 10.5 (2013): 720-734.

Neuenschwander, Beat, et al. "Robust exchangeability designs
for early phase clinical trials with multiple strata."
\emph{Pharmaceutical statistics} 15.2 (2016): 123-134.
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{setPriorParametersBerry}}
\code{\link[bhmbasket]{setPriorParametersExNex}}
\code{\link[bhmbasket]{setPriorParametersExNexAdj}}
\code{\link[bhmbasket]{setPriorParametersPooled}}
\code{\link[bhmbasket]{setPriorParametersStratified}}
\code{\link[bhmbasket]{combinePriorParameters}}
\code{\link[bhmbasket]{getMuVar}}
}
\author{
Stephan Wojciekowski
}
