% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_topic_info_df.R
\name{get_topic_info_df}
\alias{get_topic_info_df}
\title{Get Topic Information DataFrame}
\usage{
get_topic_info_df(model, drop_expanded_columns = TRUE)
}
\arguments{
\item{model}{A BERTopic model object.}

\item{drop_expanded_columns}{Logical. If TRUE, drops the expanded columns after consolidation. Default is TRUE.}
}
\value{
A data.frame or tibble with unnested and consolidated columns.
}
\description{
This function retrieves topic information from a BERTopic model and processes it to unnest
list columns, replace NA values, and consolidate columns with the same prefix.
}
\examples{
\donttest{
if (exists("topic_model")) {
  topic_info_df <- get_topic_info_df(model = topic_model,
                                     drop_expanded_columns = TRUE)
  print(topic_info_df)
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

