% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bmdsMCMC}
\alias{bmdsMCMC}
\title{MCMC for Bayesian multidimensional scaling}
\usage{
bmdsMCMC(DIST,p,nwarm = 1000,niter = 5000)
}
\arguments{
\item{DIST}{symmetric matrix of dissimilarity measures between objects}

\item{p}{number of dimensions of object configuration}

\item{nwarm}{number of iterations for  burn-in period in MCMC (default=1000)}

\item{niter}{number of MCMC iterations after burn-in period (default=5000)}
}
\value{
A list of  MCMC results
\describe{
  \item{x_bmds}{n by p matrix of object configuration that minimizes the sum of squares of residuals(SSR),
  where n is the number of objects, i.e., n=nrow(DIST)}
  \item{cmds}{n by p matrix of object configuration from the classical multidimensional scaling of Togerson(1952)}
  \item{minSSR}{minimum of sum of squares of residuals between the observed dissimilarities and 
  the estimated Euclidean distances for pairs of objects}
  \item{minSSR_id}{index of the iteration corresponding to minimum SSR}
  \item{stress}{ STRESS computed from minSSR }
  \item{e_sigma}{ posterior mean of \eqn{\sigma^2}}
  \item{var_sigma}{ posterior variance of \eqn{\sigma^2}}
  \item{SSR.L}{niter dimensional vector of posterior samples of SSR}
  \item{lam.L}{niter by  p matrix of posterior samples of elements of \eqn{\Lambda}}
  \item{sigma.L}{niter dimensional vector of posterior samples of \eqn{\sigma^2} }
  \item{del.L}{niter by \eqn{n(n-1)/2} matrix of posterior samples of \eqn{\delta}, p-dimensional Euclidean distances 
  between pairs of objects}
  }
}
\description{
run MCMC algorithm given in Oh and Raftery (2001) and return  posterior samples of
parameters as well as
 object configuration and other parameter estimates, for a given number of dimensions p
}
\examples{
\donttest{
data(cityDIST)
result=bmdsMCMC(cityDIST,p=3)
}
}
\references{
Oh, M-S., Raftery A.E. (2001). Bayesian Multidimensional Scaling and Choice of Dimension, 
Journal of the American Statistical Association, 96, 1031-1044.
}
