% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_to_delay}
\alias{truncate_to_delay}
\title{Truncate reporting triangle to a specific maximum delay}
\usage{
truncate_to_delay(x, max_delay)
}
\arguments{
\item{x}{A \link{reporting_triangle} object.}

\item{max_delay}{Integer specifying the maximum delay to retain. Must be
between 0 and the current maximum delay of the triangle.}
}
\value{
A new \link{reporting_triangle} object with delays 0 through max_delay.
}
\description{
Creates a new reporting_triangle with columns filtered to include only
delays from 0 to the specified maximum delay. This is useful when you want
to limit the delay distribution used for estimation.
}
\examples{
# Truncate to delays 0-2
rt_short <- truncate_to_delay(example_downward_corr_rt, max_delay = 2)
get_max_delay(rt_short) # Returns 2
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
