% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-getters.R
\name{get_report_dates}
\alias{get_report_dates}
\title{Compute report dates from reference dates and delays}
\usage{
get_report_dates(reference_dates, delays, delays_unit)
}
\arguments{
\item{reference_dates}{Date vector of reference dates.}

\item{delays}{Numeric vector of delays.}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}
}
\value{
Date vector of report dates.
}
\description{
Adds delays to reference dates using unit-aware date arithmetic.
}
\examples{
# Compute report dates with days
ref_date <- as.Date("2024-01-01")
get_report_dates(ref_date, 7, "days") # 2024-01-08

# Compute report dates with weeks
get_report_dates(ref_date, 2, "weeks") # 2024-01-15
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
