% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocate Address}
\usage{
ec2_allocate_address(
  Domain = NULL,
  Address = NULL,
  PublicIpv4Pool = NULL,
  NetworkBorderGroup = NULL,
  CustomerOwnedIpv4Pool = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Domain}{Character.   Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic....[optional]}

\item{Address}{Character. [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.[optional]}

\item{PublicIpv4Pool}{Character. The ID of an address pool that you own.[optional]}

\item{NetworkBorderGroup}{Character.   A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises...[optional]}

\item{CustomerOwnedIpv4Pool}{Character. The ID of a customer-owned address pool.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to assign to the Elastic IP address.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Allocate Address
}
\section{Domain}{


Indicates whether the Elastic IP address is for use with instances in a
VPC or instances in EC2-Classic.

Default: If the Region supports EC2-Classic, the default is \code{standard}.
Otherwise, the default is \code{vpc}.
}

\section{Address}{

[EC2-VPC] The Elastic IP address to recover or an
IPv4 address from an address pool.
}

\section{PublicIpv4Pool}{

The ID of an
address pool that you own. Use this parameter to let Amazon EC2 select
an address from the address pool. To specify a specific address from the
address pool, use the \code{Address} parameter instead.
}

\section{NetworkBorderGroup}{


A unique set of Availability Zones, Local Zones, or Wavelength Zones
from which AWS advertises IP addresses. Use this parameter to limit the
IP address to this location. IP addresses cannot move between network
border groups.

Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html}{DescribeAvailabilityZones}
to view the network border groups.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.
}

\section{CustomerOwnedIpv4Pool}{

The ID of a customer-owned address pool. Use this
parameter to let Amazon EC2 select an address from the address pool.
Alternatively, specify a specific address from the address
pool.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to assign to the
Elastic IP address.
}

