% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agronomic_analysis.R
\name{stability_analysis}
\alias{stability_analysis}
\title{============================================================================
ADVANCED AGRONOMIC STATISTICAL METHODS
Package: aridagri
Authors: Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
ICAR-Indian Institute of Pulses Research, Regional Centre, Bikaner
ICAR-Indian Institute of Groundnut Research, Regional Research Station, Bikaner
============================================================================
Stability Analysis for Agronomic Traits (Multiple Methods)}
\usage{
stability_analysis(
  data,
  genotype,
  environment,
  replication,
  trait,
  method = "all",
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame with genotype/treatment, environment, replication, and trait}

\item{genotype}{Name of genotype/treatment column}

\item{environment}{Name of environment/location/year column}

\item{replication}{Name of replication column}

\item{trait}{Name of trait/response variable}

\item{method}{Method: "eberhart", "ammi", "finlay", "shukla", "wricke", "cv", "superiority", or "all"}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing stability parameters and rankings
}
\description{
Performs comprehensive stability analysis using multiple established methods for 
evaluating genotype/treatment performance across environments.

Methods included:
\itemize{
  \item Eberhart & Russell (1966): Regression approach
  \item AMMI: Additive Main effects and Multiplicative Interaction
  \item Finlay & Wilkinson (1963): Linear regression on environmental mean
  \item Shukla (1972): Stability variance
  \item Wricke (1962): Ecovalence
  \item Coefficient of Variation: CV-based ranking
  \item Superiority Index: Lin & Binns (1988)
}
}
\examples{
data <- expand.grid(
  variety = paste0("V", 1:10),
  location = paste0("L", 1:5),
  rep = 1:3
)
data$yield <- rnorm(nrow(data), 1200, 200)

stability_analysis(data, genotype = "variety", environment = "location",
                   replication = "rep", trait = "yield", method = "all")

}
\references{
Eberhart, S.A. and Russell, W.A. (1966). Crop Science, 6: 36-40.
}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
