% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nutrient_functions.R
\name{nue_calculate}
\alias{nue_calculate}
\title{Nutrient Use Efficiency Calculations}
\usage{
nue_calculate(
  yield_fertilized,
  yield_control,
  nutrient_applied,
  nutrient_uptake_fert = NULL,
  nutrient_uptake_ctrl = NULL,
  biomass_fert = NULL,
  biomass_ctrl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{yield_fertilized}{Yield with fertilizer application (kg/ha)}

\item{yield_control}{Yield in control/unfertilized plot (kg/ha)}

\item{nutrient_applied}{Amount of nutrient applied (kg/ha)}

\item{nutrient_uptake_fert}{Nutrient uptake in fertilized plot (kg/ha), optional}

\item{nutrient_uptake_ctrl}{Nutrient uptake in control plot (kg/ha), optional}

\item{biomass_fert}{Total biomass in fertilized plot (kg/ha), optional}

\item{biomass_ctrl}{Total biomass in control plot (kg/ha), optional}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
Data frame with efficiency indices
}
\description{
Comprehensive nutrient use efficiency calculations including Agronomic Efficiency (AE),
Physiological Efficiency (PE), Apparent Recovery Efficiency (ARE), and Partial Factor
Productivity (PFP). Essential for INM research in arid regions.
}
\details{
Efficiency calculations:
\itemize{
  \item AE (Agronomic Efficiency) = (Yield_fert - Yield_ctrl) / Nutrient_applied
  \item PFP (Partial Factor Productivity) = Yield_fert / Nutrient_applied
  \item ARE (Apparent Recovery Efficiency) = (Uptake_fert - Uptake_ctrl) / Nutrient_applied  100
  \item PE (Physiological Efficiency) = (Yield_fert - Yield_ctrl) / (Uptake_fert - Uptake_ctrl)
}
}
\examples{
# Basic NUE calculation
nue_calculate(yield_fertilized = 1850, yield_control = 1200, nutrient_applied = 40)

# Complete NUE with uptake data
nue_calculate(
  yield_fertilized = 1850, 
  yield_control = 1200,
  nutrient_applied = 40,
  nutrient_uptake_fert = 65,
  nutrient_uptake_ctrl = 35
)

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
