% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{posterior_mixture}
\alias{posterior_mixture}
\title{Posterior mixture across studies}
\usage{
posterior_mixture(theta_list, weights)
}
\arguments{
\item{theta_list}{List of numeric vectors of posterior draws}

\item{weights}{Numeric vector of study weights}
}
\value{
A list containing mixture draws and summaries
}
\description{
Combines posterior draws across studies using a weighted mixture
}
\examples{
# Simulate posterior draws from two studies
theta1 <- rnorm(1000, mean = -0.6, sd = 0.1)
theta2 <- rnorm(1000, mean = -0.4, sd = 0.15)

# Combine using relevance weights
mix <- posterior_mixture(
  theta_list = list(theta1, theta2),
  weights = c(0.6, 0.4)
)

# Mixture draws
head(mix$draws)

# Posterior summary (mean and 95\% credible interval)
mix$summary
}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272.
}
\seealso{
\itemize{
\item \code{\link{posterior_probability}}
\item \code{\link{posterior_summary}}
\item \code{vignette("appraise-introduction")}
}
}
