% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress.R
\name{compress_adf}
\alias{compress_adf}
\alias{decompress_adz}
\title{Compress ADF to ADZ files and vice versa}
\usage{
compress_adf(source, destination)

decompress_adz(source, destination)
}
\arguments{
\item{source}{Path to the source file to read.}

\item{destination}{Path to the destination file to write.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
The ADZ format is essentially a compressed (gzip) version of the
Amiga Disk File (ADF) format. The \code{adfExplorer} allows you to connect
to both formats. However, you can only open a 'read-only' connection
to ADZ files. Use the compression and decompression functions documented
here to move back and forth from and to ADF and ADZ formats.
}
\examples{
adz_file  <- system.file("example.adz", package = "adfExplorer")
adf_file  <- tempfile(fileext = ".adf")
adz_file2 <- tempfile(fileext = ".adz")

decompress_adz(adz_file, adf_file)
compress_adf(adf_file, adz_file2)
}
\author{
Pepijn de Vries
}
