% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_release_utils.R
\name{compare_sqlite_to_release}
\alias{compare_sqlite_to_release}
\title{Compare local SQLite database to GitHub release hash}
\usage{
compare_sqlite_to_release(
  owner,
  repo,
  asset_name,
  local_sqlite_path,
  tag = NULL,
  token = Sys.getenv("GITHUB_PAT"),
  algo = "sha256"
)
}
\arguments{
\item{owner}{Repository owner.}

\item{repo}{Repository name.}

\item{asset_name}{Name of the SQLite asset (used to derive hash filename).}

\item{local_sqlite_path}{Path to local SQLite database.}

\item{tag}{Optional release tag. If NULL, uses latest release.}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}

\item{algo}{Hash algorithm (default: \code{"sha256"}).}
}
\value{
TRUE if hashes match, FALSE otherwise.
}
\description{
Compares the SHA256 hash of a local SQLite database file
with the hash file stored in a GitHub release.
}
\details{
This avoids downloading the full database when checking
for updates.
}
\examples{
\dontrun{
compare_sqlite_to_release(
  owner = "myuser",
  repo = "myrepo",
  asset_name = "database.sqlite",
  local_sqlite_path = "database.sqlite"
)
}
}
