% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectrix.R
\name{Vectrix}
\alias{Vectrix}
\title{VectrixDB Easy API - The Simplest Vector Database}
\description{
Zero config. Text in, results out. One line for everything.
}
\examples{
\dontrun{
# Create and add - ONE LINE
db <- Vectrix$new("my_docs")$add(c("Python is great", "Machine learning is fun"))

# Search - ONE LINE
results <- db$search("programming")

# Full power - STILL ONE LINE
results <- db$search("AI", mode = "ultimate")  # dense + sparse + rerank
}


## ------------------------------------------------
## Method `Vectrix$new`
## ------------------------------------------------

\dontrun{
# Default TF-IDF embeddings (no external files needed)
db <- Vectrix$new("docs")

# With GloVe 100d word vectors (auto-downloads ~130MB)
db <- Vectrix$new("docs", model = "glove-100")

# With pre-downloaded GloVe
db <- Vectrix$new("docs", model_path = "path/to/glove.6B.100d.txt")

# Custom embedding function
db <- Vectrix$new("docs", embed_fn = my_embed_function, dimension = 768)
}

## ------------------------------------------------
## Method `Vectrix$add`
## ------------------------------------------------

\dontrun{
db$add(c("text 1", "text 2"))
db$add("another text", metadata = list(source = "web"))
}

## ------------------------------------------------
## Method `Vectrix$search`
## ------------------------------------------------

\dontrun{
results <- db$search("python programming")
results <- db$search("AI", mode = "ultimate", rerank = "mmr")
print(results$top()$text)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Collection name}

\item{\code{path}}{Storage path}

\item{\code{dimension}}{Vector dimension}

\item{\code{model_name}}{Model identifier}

\item{\code{model_type}}{Model type}

\item{\code{language}}{Language setting}

\item{\code{tier}}{Storage tier}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Vectrix-new}{\code{Vectrix$new()}}
\item \href{#method-Vectrix-add}{\code{Vectrix$add()}}
\item \href{#method-Vectrix-set_language}{\code{Vectrix$set_language()}}
\item \href{#method-Vectrix-search}{\code{Vectrix$search()}}
\item \href{#method-Vectrix-delete}{\code{Vectrix$delete()}}
\item \href{#method-Vectrix-clear}{\code{Vectrix$clear()}}
\item \href{#method-Vectrix-count}{\code{Vectrix$count()}}
\item \href{#method-Vectrix-get}{\code{Vectrix$get()}}
\item \href{#method-Vectrix-similar}{\code{Vectrix$similar()}}
\item \href{#method-Vectrix-close}{\code{Vectrix$close()}}
\item \href{#method-Vectrix-print}{\code{Vectrix$print()}}
\item \href{#method-Vectrix-clone}{\code{Vectrix$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-new"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-new}{}}}
\subsection{Method \code{new()}}{
Create or open a VectrixDB collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$new(
  name = "default",
  path = NULL,
  model = NULL,
  dimension = NULL,
  embed_fn = NULL,
  model_path = NULL,
  language = NULL,
  tier = "dense",
  auto_download = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}

\item{\code{path}}{Storage path. Defaults to a session temp directory.}

\item{\code{model}}{Embedding model: "tfidf" (default), "glove-50", "glove-100",
"glove-200", "glove-300", or "word2vec"}

\item{\code{dimension}}{Vector dimension (auto-detected for GloVe)}

\item{\code{embed_fn}}{Custom embedding function: fn(texts) -> matrix}

\item{\code{model_path}}{Path to pre-trained word vectors (GloVe .txt or word2vec .bin)}

\item{\code{language}}{Language behavior: "en" (English-focused) or "ml" (multilingual/Unicode)}

\item{\code{tier}}{Storage tier: "dense", "hybrid", "ultimate", or "graph"}

\item{\code{auto_download}}{Automatically download GloVe vectors if needed (default: TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# Default TF-IDF embeddings (no external files needed)
db <- Vectrix$new("docs")

# With GloVe 100d word vectors (auto-downloads ~130MB)
db <- Vectrix$new("docs", model = "glove-100")

# With pre-downloaded GloVe
db <- Vectrix$new("docs", model_path = "path/to/glove.6B.100d.txt")

# Custom embedding function
db <- Vectrix$new("docs", embed_fn = my_embed_function, dimension = 768)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-add"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-add}{}}}
\subsection{Method \code{add()}}{
Add texts to the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$add(texts, metadata = NULL, ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Single text or character vector of texts}

\item{\code{metadata}}{Optional metadata list or list of lists}

\item{\code{ids}}{Optional custom IDs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
db$add(c("text 1", "text 2"))
db$add("another text", metadata = list(source = "web"))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-set_language"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-set_language}{}}}
\subsection{Method \code{set_language()}}{
Update collection language behavior
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$set_language(language = "en")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{language}}{Language behavior: "en" or "ml"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-search"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-search}{}}}
\subsection{Method \code{search()}}{
Search the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$search(
  query,
  limit = 10,
  mode = "hybrid",
  rerank = NULL,
  filter = NULL,
  diversity = 0.7
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query text}

\item{\code{limit}}{Number of results (default: 10)}

\item{\code{mode}}{Search mode: "dense", "sparse", "hybrid", "ultimate"}

\item{\code{rerank}}{Reranking method: NULL, "mmr", "exact", "cross-encoder"}

\item{\code{filter}}{Metadata filter}

\item{\code{diversity}}{Diversity parameter for MMR (0-1)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Results object with search results
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
results <- db$search("python programming")
results <- db$search("AI", mode = "ultimate", rerank = "mmr")
print(results$top()$text)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-delete}{}}}
\subsection{Method \code{delete()}}{
Delete documents by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$delete(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Document ID(s) to delete}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all documents from collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-count"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-count}{}}}
\subsection{Method \code{count()}}{
Get number of documents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-get"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-get}{}}}
\subsection{Method \code{get()}}{
Get documents by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$get(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Document ID(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of Result objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-similar"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-similar}{}}}
\subsection{Method \code{similar()}}{
Find similar documents to a given document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$similar(id, limit = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Document ID}

\item{\code{limit}}{Number of results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Results object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-close"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-close}{}}}
\subsection{Method \code{close()}}{
Close the database connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-print"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-print}{}}}
\subsection{Method \code{print()}}{
Print Vectrix summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Vectrix-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Vectrix-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Vectrix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
