% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lm.R
\name{lm.best}
\alias{lm.best}
\title{Title: Fitting linear models for the best model}
\usage{
lm.best(object, method = "models", threshold = 0.95, x = FALSE, y = FALSE)
}
\arguments{
\item{object}{the model selection result from \code{modelselect.lm}.}

\item{method}{the criteria to do model select.
\code{method = "models"} selects the best model by the highest posterior probabilities.
\code{method = "variables"} selects the variables in the best model by the posterior inclusion probabilities which are larger than the threshold.}

\item{threshold}{The threshold for variable selection. The variables with posterior inclusion probability larger than the threshold are selected in the best model. The default is 0.95.}

\item{x, y}{logicals. If \code{TRUE} the corresponding components (the best model predictor matrix, the response) of the fit are returned.}
}
\value{
An object of class \code{"lm"}, which is a list containing the following components:
\describe{
\item{\code{coefficients}}{A named vector of coefficients.}
\item{\code{residuals}}{The residuals, that is the response minus the fitted values.}
\item{\code{fitted.values}}{The fitted mean values.}
\item{\code{rank}}{The numeric rank of the fitted linear model.}
\item{\code{df.residual}}{The residual degrees of freedom.}
\item{\code{call}}{The matched call.}
\item{\code{terms}}{The \code{terms} object used.}
\item{\code{model}}{(If requested) the model frame used.}
\item{\code{qr}}{(If requested) the QR decomposition of the design matrix.}
\item{\code{xlevels}}{(If the model formula includes factors) a record of the levels of the factors.}
\item{\code{contrasts}}{(If the model formula includes factors) the contrasts used.}
\item{\code{offset}}{The offset used.}
\item{\code{threshold}}{the threshold used for method = "variables".}
}
}
\description{
Description: \code{lm.best} is used to fit linear model for the best model provided by \code{modelselect.lm}.
}
