% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{TEST.mean}
\alias{TEST.mean}
\title{Test on the mean}
\usage{
TEST.mean(
  x,
  sigma = NULL,
  mu0 = 0,
  alternative = "two.sided",
  digits = 2,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x}{An unquoted string identifying the \emph{numeric}
variable whose mean is of interest. \code{x} can be the
name of a vector in the workspace or the name of one of
the columns in the data frame specified in the \code{data} argument.}

\item{sigma}{An optional numeric value specifying the
population standard deviation. If \code{NULL} (default)
the population standard deviation is estimated using the
data.}

\item{mu0}{Numeric value that specifies the null hypothesis to test for
(default is 0).}

\item{alternative}{A length-one character vector specifying the direction
of the alternative hypothesis. Allowed values are \code{"two.sided"}
(population mean differs from \code{mu0}; default), or \code{"less"}
(population mean is lower than \code{mu0}), or \code{"greater"}
(population mean is higher than \code{mu0}).}

\item{digits}{Integer value specifying the number of
decimals used to round statistics; default to 2. If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether reported values
should be forcedly rounded to the number of decimals specified in
\code{digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x}.
If not found in \code{data}, \code{x} is taken from the environment
from which \code{TEST.mean()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table reporting the results of the test on the population mean.
If the variance is unknown, the test is run using percentiles from
both the normal and the Student's t distribution.
}
\description{
\code{TEST.mean()}  tests hypotheses on the mean of a population.
}
\examples{
data(MktDATA, package = "UBStats")

# Test on the mean; KNOWN variance
# - Bilateral test
TEST.mean(NStore_Purch, sigma = 9, mu0 = 5, 
          alternative = "two.sided", data = MktDATA)
# - Unilateral test
TEST.mean(NStore_Purch, sigma = 9,mu0 = 5,
          alternative = "greater", data = MktDATA)

# Test on the mean; UNKNOWN variance;
# - Unilateral test
TEST.mean(TotVal, mu0 = 600, alternative = "less",
          data = MktDATA)

# Arguments force.digits and use.scientific
# An input variable taking very low values
SmallX<-MktDATA$AOV/500
# Default output
TEST.mean(SmallX, mu0 = 0.1)
# Request to use the exact number of digits (default, 2)
TEST.mean(SmallX, mu0 = 0.1,force.digits=TRUE)
# Request to allow scientific notation
TEST.mean(SmallX, mu0 = 0.1,use.scientific=TRUE)

# Output results
out.test_mean<-TEST.mean(TotVal, mu0 = 600, alternative = "less",
                         data = MktDATA)

}
\seealso{
\code{\link{CI.mean}()} to build confidence intervals for the
population mean.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
