% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{MSTEdges}
\alias{MSTEdges}
\alias{MSTLength}
\title{Minimum spanning tree}
\usage{
MSTEdges(distances, plot = FALSE, x = NULL, y = NULL, ...)

MSTLength(distances, mst = NULL)
}
\arguments{
\item{distances}{Either a matrix that can be interpreted as a distance
matrix, or an object of class \code{dist}.}

\item{plot}{Logical specifying whether to add the minimum spanning tree
to an existing plot.}

\item{x, y}{Numeric vectors specifying the X and Y coordinates of each
element in \code{distances}.  Necessary only if \code{plot = TRUE}.}

\item{\dots}{Additional parameters to send to \verb{[lines()]}.}

\item{mst}{Optional parameter specifying the minimum spanning tree in the
format returned by \code{MSTEdges()}; if \code{NULL}, calculated from \code{distances}.}
}
\value{
\code{MSTEdges()} returns a matrix in which each row corresponds to an
edge of the minimum spanning tree, listed in non-decreasing order of length.
The two columns contain the indices of the entries in \code{distances} that
each edge connects, with the lower value listed first.

\code{MSTLength()} returns the length of the minimum spanning tree.
}
\description{
Calculate or plot the minimum spanning tree \insertCite{Gower1969}{TreeTools}
of a distance matrix.
}
\examples{
# Corners of an almost-regular octahedron
points <- matrix(c(0, 0, 2, 2, 1.1, 1,
                   0, 2, 0, 2, 1, 1.1,
                   0, 0, 0, 0, 1, -1), 6)
distances <- dist(points)
mst <- MSTEdges(distances)
MSTLength(distances, mst)
plot(points[, 1:2], ann = FALSE, asp = 1)
MSTEdges(distances, TRUE, x = points[, 1], y = points[, 2], lwd = 2)
}
\references{
\insertAllCited{}
}
\seealso{
Slow implementation returning the association matrix of the minimum spanning
tree: \code{\link[ape:mst]{ape::mst()}}.

Other utility functions: 
\code{\link{ClusterTable}},
\code{\link{ClusterTable-methods}},
\code{\link{Hamming}()},
\code{\link{SampleOne}()},
\code{\link{TipTimedTree}()},
\code{\link{UnshiftTree}()},
\code{\link{as.multiPhylo}()},
\code{\link{match,phylo,phylo-method}},
\code{\link{sapply64}()},
\code{\link{sort.multiPhylo}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
