% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_core.R
\name{prepare_dat_bin}
\alias{prepare_dat_bin}
\title{Prepare analysis data frame for QCA::truthTable()}
\usage{
prepare_dat_bin(
  dat,
  outcome_clean,
  conditions,
  thrY,
  thrX_vec,
  pre_calibrated = NULL
)
}
\arguments{
\item{dat}{Original data frame.}

\item{outcome_clean}{Character. Outcome variable name (without \code{~}).}

\item{conditions}{Character vector. Condition variable names.}

\item{thrY}{Numeric. Threshold for outcome binarization.}

\item{thrX_vec}{Named numeric vector. Thresholds for conditions.}

\item{pre_calibrated}{Character vector or NULL. Names of pre-calibrated
variables to pass through without binarization.}
}
\value{
Data frame with column \code{Y} (binarized outcome) and condition
  columns (binarized or passed through).
}
\description{
Constructs the data frame to be passed to \code{QCA::truthTable()}.
For pre-calibrated variables, the original values are passed through
without binarization. For all other variables, \code{qca_bin()} is applied.
}
\keyword{internal}
