% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plot_survHE.R
\name{theme_survHE}
\alias{theme_survHE}
\title{A Custom ggplot2 Theme for Survival Plots}
\usage{
theme_survHE()
}
\value{
A ggplot2 theme object that can be added to a ggplot.
}
\description{
This theme is designed for use with survival analysis plots, particularly
those created using the \code{survHE} package. It builds on \code{theme_bw()} and
customizes axis text, titles, plot background, and legend styling.
}
\details{
Note: To position the legend inside the plot, use an additional call to
\code{theme(legend.position = c(x, y), legend.justification = c("left", "top"))}.
}
\examples{
library(ggplot2)
library(survHE)
ggplot(mtcars, aes(wt, mpg)) +
 geom_point() +
 theme_survHE() +
 theme(legend.position = c(0.6, 0.8), legend.justification = c("left", "top"))
}
