% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Longmemorytest.R
\name{Longmemorytest}
\alias{Longmemorytest}
\title{Testing true long memory against spurious long memory}
\usage{
Longmemorytest(
  x,
  demean = TRUE,
  alpha = 0.05,
  filter = TRUE,
  print_results = TRUE
)
}
\arguments{
\item{x}{Numeric vector of time series data}

\item{demean}{Logical, demean the series (default: TRUE)}

\item{alpha}{Numeric, significance level: 0.01, 0.025, 0.05, or 0.10 (default: 0.05)}

\item{filter}{Logical, apply a pre-whitening filter to reduce short-memory dynamics that may otherwise affect the size of the test in finite samples (default: TRUE).}

\item{print_results}{Logical, print results (default: TRUE)}
}
\value{
A list with elements:
\item{d_estimate}{Local Whittle estimate of the long memory parameter.}
\item{test_stat_eps02}{Test statistic with trimming parameter epsilon = 0.02.}
\item{test_stat_eps05}{Test statistic with trimming parameter epsilon = 0.05.}
\item{critical_value_eps02}{Critical value for epsilon = 0.02 at the chosen significance level alpha.}
\item{critical_value_eps05}{Critical value for epsilon = 0.05 at the chosen significance level alpha.}
\item{reject_eps02}{Logical, TRUE if the null is rejected for epsilon = 0.02.}
\item{reject_eps05}{Logical, TRUE if the null is rejected for epsilon = 0.05.}
\item{alpha}{Significance level.}
\item{m}{Bandwidth parameter m.}
\item{n}{Sample size.}
}
\description{
Tests the null hypothesis of true long memory against the alternative of spurious long memory (e.g., due to level shifts or trends) using the Qu (2011) test.
}
\details{
The test uses bandwidth parameter m = n^0.7 with trimming parameters 0.02 or 0.05 as recommended by Qu (2011). Critical values are based on these settings. Whether the pre-whitening filter is applied does not affect the asymptotic critical values.
}
\examples{
data(RV5min)
result <- Longmemorytest(log(RV5min))

# Simulated example: ARFIMA(0,d,0) with d = 0.3 (true long memory)
set.seed(123)
n  <- 2000
d0 <- 0.3
e  <- rnorm(n)
x  <- fracdiff::fracdiff.sim(n, d = d0)$series

# Apply the test (null = true long memory)
out <- Longmemorytest(x, alpha = 0.05)
out$reject_eps02    # typically FALSE
out$d_estimate

# Example: Spurious long memory due to a structural break
set.seed(123)
n <- 2000
x <- c(rnorm(n/2, 0, 1), rnorm(n/2, 2, 1))   # one-time mean shift

out <- Longmemorytest(x, alpha = 0.05)
out$reject_eps02
out$reject_eps05

}
\references{
Qu, Z. (2011). A Test Against Spurious Long Memory. Journal of Business & Economic Statistics, 29(3), 423-438.
}
