% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_seurat_markers.R
\name{Read_seurat_markers}
\alias{Read_seurat_markers}
\title{Create "Marker_list" from Seurat object}
\usage{
Read_seurat_markers(
  df,
  sources = c("Seurat", "presto"),
  sort_by = "FSS",
  gene_filter = 20
)
}
\arguments{
\item{df}{Dataframe generated by "FindAllMarkers" function, recommend
to use parameter "group.by = "Cell_type"" and "only.pos = TRUE".}

\item{sources}{Type of markers sources to use. Be one of: \code{"Seurat"} or \code{"presto"}.}

\item{sort_by}{Marker sorting parameter, for Seurat sources, select "avg_log2FC" or
"p_val_adj" or "FSS" (Feature Significance Score, FSS, product value of \code{log2FC}
and \verb{Expression ratio}). Default parameters use "sort_by = 'FSS'".for presto
sources, select "logFC" or "padj" or "FSS". Default parameters use "sort_by = 'FSS'".}

\item{gene_filter}{The number of markers left for each cell type based
on the "sort_by" parameter's level of difference. Default parameters use
"gene_fliter = 20"}
}
\value{
The standardized "Marker_list" in the SlimR package.
}
\description{
Create "Marker_list" from Seurat object
}
\examples{
\dontrun{
# Example for Seurat sources markers
seurat_markers <- Seurat::FindAllMarkers(
    object = sce,
    group.by = "Cell_type",
    only.pos = TRUE)

Markers_list_Seurat <- Read_seurat_markers(seurat_markers,
    sources = "Seurat",
    sort_by = "avg_log2FC",
    gene_filter = 20
    )

# Example for presto sources markers
seurat_markers <- dplyr::filter(
    presto::wilcoxauc(
      X = sce,
      group_by = "Cell_type",
      seurat_assay = "RNA"
      ),
    padj < 0.05, logFC > 0.5
    )

Markers_list_Seurat <- Read_seurat_markers(seurat_markers,
    sources = "presto",
    sort_by = "logFC",
    gene_filter = 20
    )
}

}
\seealso{
Other Section_2_Standardized_Markers_List: 
\code{\link{Markers_filter_Cellmarker2}()},
\code{\link{Markers_filter_PanglaoDB}()},
\code{\link{Read_excel_markers}()}
}
\concept{Section_2_Standardized_Markers_List}
